package h.com.serialapp.activity.fragment


import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import h.com.serialapp.R
import h.com.serialapp.adapter.LogAdapter
import h.com.serialapp.util.ToastUtil
import h.com.serialportapi.comn.CommPacket
import h.com.serialportapi.comn.Packet
import h.com.serialportapi.comn.SerialPortManager
import h.com.serialportapi.comn.SerialReadThread
import h.com.serialportapi.comn.message.ICMessage
import h.com.serialportapi.comn.message.IMessage
import h.com.serialportapi.comn.message.LogManager
import kotlinx.android.synthetic.main.view_iso1444334.view.*

/**
 * Created by hxd on 2018/10/21.
 */
class ISO1444334 : BasesFragment() {

    var logAdapter: LogAdapter = LogAdapter()
    lateinit var views: View
    lateinit var message: String

    var handler = Handler(Handler.Callback { msg ->
        when (msg.what) {
            1 -> {
                views.et_tag_type.setText(icObject.tag_Type)
                views.et_sak.setText(icObject.sak)
                views.et_uid_number.setText(icObject.uiD_number)
            }
            2 -> {
                views.et_sendRATS.setText(current.substring(4, current.length - 2))
            }
        }
        false
    })

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        var view = inflater!!.inflate(R.layout.view_iso1444334, null)
//        view.bt_idle.setOnClickListener { sendData("50000222102646") }
////        view.bt_all.setOnClickListener {
////            sendData("50000222105232")}
//        println(Packet(s,50,2,22).sendData)
//        view.bt_all.setOnClickListener {
//           sendData(Packet(s,50,2,22).sendData)}
        view.lv_log.adapter = logAdapter
        views = view
//        demoFun()
        PICCActivityListener()
        return view
    }

    private fun sendData(str: String) {
        val text = str
        if (TextUtils.isEmpty(text) || text.length % 2 != 0) {
            ToastUtil.showOne(activity, "无效数据")
            return
        }

        SerialPortManager.instance().sendCommand(text)
    }

    override fun add(message: IMessage) {
        logAdapter.add(message)
        views.lv_log.setSelection(logAdapter.count - 1)
    }

    /*演示通用方法*/
    fun demoFun() {
        var idle = byteArrayOf(10, 26)
        //IDLE请求模式
        views.bt_all.setOnClickListener {
            CommPacket.GeneralRequest(Packet(idle, 50, 2, 22).sendData, SerialReadThread.ReaderListener { msg ->
                message = msg
                println(message)
            })
        }
        var all = byteArrayOf(10, 52)
        //ALL请求模式
        views.bt_idle.setOnClickListener {
            CommPacket.GeneralRequest(Packet(all, 50, 2, 22).sendData, SerialReadThread.ReaderListener { msg ->
                message = msg
                println(message)
            })
        }
    }

    lateinit var icObject: ICMessage
    lateinit var current: String

    /*演示通用方法*/
    fun PICCActivityListener() {
        var all = byteArrayOf(10, 52)
        //ALL请求模式
        views.bt_all.setOnClickListener {
            CommPacket.PiccActivate(Packet(all, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }
        var idle = byteArrayOf(10, 26)
        //IDLE请求模式
        views.bt_idle.setOnClickListener {
            CommPacket.PiccActivate(Packet(idle, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }
        views.btn_clear_log.setOnClickListener {
            LogManager.instance().clear()
            logAdapter.notifyDataSetChanged()
        }

        /*--------------------------------------------------------------------------*/
        views.bt_sendRATS.setOnClickListener {
            CommPacket.PiccRequestATS(null, SerialReadThread.ReaderListener { msg ->
                current = msg
                handler.sendEmptyMessage(2)
            })
        }
        views.bt_sendAPDU.setOnClickListener {
            CommPacket.PiccAPDU(views.et_apdu.text.toString(), SerialReadThread.ReaderListener { message ->
                //                icObject = message
//                handler.sendEmptyMessage(1)
            })
        }
        views.bt_apduChannel.setOnClickListener {
            CommPacket.PiccTransfer(views.et_apduChannel.text.toString(), SerialReadThread.ReaderListener { message ->
                //                icObject = message
//                handler.sendEmptyMessage(1)
            })
        }
    }

}